<?php

namespace App\Domain;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Delegacja extends Model 
{

    protected $table = 'delegacje';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('delegowany_id', 'akceptujacy_id', 'cel', 'data_od', 'data_do', 'status');

    public function delegowany()
    {
        return $this->belongsTo('App\Domain\Osoba');
    }

    public function akceptujacy()
    {
        return $this->belongsTo('App\Domain\Osoba');
    }

}